<?php
/***********************************************************************************************************************************************/
/* change the 'myemail@domain.com' to your email address, that's email where the forms send the message (contact, newsletter subscription) */
define("WEBMASTER_EMAIL", 'myemail@domain.com');
/***********************************************************************************************************************************************/

// no post data or not type set, exit:
if(empty($_POST) || empty($_GET['type'])) {
	header('HTTP/1.1 500');
	exit();
}

// form validation errors 
$errors = '';

// contact or newsletter form?
switch (strtolower($_GET['type'])) {
	case 'contact':
		$name = stripslashes($_POST['name']);
		$email = trim($_POST['email']);
		$subject = stripslashes($_POST['subject']);
		$message = htmlspecialchars($_POST['message']);

		if(!$name)
			$errors .= "Please enter Your name.\n";
		if(!$email)
			$errors .= "Please enter Your email.\n";
		if($email && !isValidEmail($email))
			$errors .= "Please enter valid email.\n";
		if(!$subject)
			$errors .= "Please enter message subject.\n";
		if(!$message)
			$errors .= "Please enter Your message.\n";
			
		if($errors == '')
			sendmail($name,$email,$subject,$message);
		feedback('contact-feedback.php');
		break;
	case 'newsletter':
		$email = trim($_POST['newsletter_email']);
		if(!$email)
			$errors .= "Please enter Your email.\n";
		if($email && !isValidEmail($email))
			$errors .= "Please enter valid email.\n";
			
		if($errors == '')
			sendmail('',$email,'Newsletter subscription', '');
		feedback('newsletter-feedback.php');
		break;
}

// sends email
function sendmail($name ='', $email, $subject, $message = "") {
	global $errors;
	$mail = mail(WEBMASTER_EMAIL, $subject, $message,
	 "From: ".$name." <".$email.">\r\n"
	."Reply-To: ".$name."<".$email.">\r\n"
	."X-Mailer: PHP/" . phpversion());
	if(!$mail)
		$errors .= "Email sending error.\n";
}

// displays possible errors and feedback page
function feedback($filename) {
	global $errors;
	if($errors != '')
		$errors=implode("<br />", explode("\n", $errors));
	include($filename);
	exit();
}

// PHP 5.x only: http://www.snipplr.com/view/10897/valid-email-address-filter/
function isValidEmail($email){
	if(!$email)
		return FALSE;
	if(!filter_var($email, FILTER_VALIDATE_EMAIL))
		return FALSE;
	return TRUE;
}
?>